/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.component;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import org.adempiere.webui.component.Tabpanel;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.SelectEvent;
import org.zkoss.zul.Tab;
import org.zkoss.zul.Tabpanels;

public class Tabbox
extends org.zkoss.zul.Tabbox
implements EventListener<Event> {
    private static final long serialVersionUID = 1400484283064851775L;
    private boolean isSupportTabDragDrop = false;
    private boolean isActiveBySeq = false;
    private boolean isCheckVisibleOnlyForNextActive = true;
    private Deque<Tab> activeTabSeq = new ArrayDeque<Tab>();

    public Tabbox() {
        this.addEventListener("onSelect", this);
    }

    public Tabpanel getTabpanel(int index) {
        try {
            Tabpanels tabpanels = this.getTabpanels();
            Tabpanel tabPanel = (Tabpanel)tabpanels.getChildren().get(index);
            return tabPanel;
        }
        catch (Exception ex) {
            throw new IndexOutOfBoundsException(ex.getMessage());
        }
    }

    public Tabpanel getSelectedTabpanel() {
        return this.getTabpanel(this.getSelectedIndex());
    }

    public boolean isSupportTabDragDrop() {
        return this.isSupportTabDragDrop;
    }

    public void setSupportTabDragDrop(boolean isSupportTabDragDrop) {
        this.isSupportTabDragDrop = isSupportTabDragDrop;
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        Events.sendEvent((String)"onPageAttached", (Component)this, null);
    }

    public void onPageDetached(Page page) {
        super.onPageDetached(page);
        Events.sendEvent((String)"onPageDetached", (Component)this, null);
    }

    public void onEvent(Event event) throws Exception {
        SelectEvent selectEvent;
        Iterator itPrevSelectedTab;
        if (event instanceof SelectEvent && this.isActiveBySeq() && (itPrevSelectedTab = (selectEvent = (SelectEvent)event).getPreviousSelectedItems().iterator()).hasNext()) {
            this.activeTabSeq.push((Tab)itPrevSelectedTab.next());
        }
    }

    public void setSelectedTab(Tab tab) {
        if (this.getSelectedTab() != null && this.getSelectedTab() != tab && this.isActiveBySeq()) {
            this.activeTabSeq.push(this.getSelectedTab());
        }
        super.setSelectedTab(tab);
    }

    public boolean isActiveBySeq() {
        return this.isActiveBySeq;
    }

    public void setActiveBySeq(boolean isActiveBySeq) {
        this.isActiveBySeq = isActiveBySeq;
    }

    public Tab getNextActiveBySeq(Tab currentTab) {
        Tab cadidateTabActive = null;
        while ((cadidateTabActive = this.activeTabSeq.peek()) != null) {
            boolean canNotActive;
            boolean bl = canNotActive = cadidateTabActive.isDisabled() || !cadidateTabActive.isVisible() && this.isCheckVisibleOnlyForNextActive();
            if (canNotActive) {
                cadidateTabActive = this.activeTabSeq.pop();
                this.activeTabSeq.addLast(cadidateTabActive);
                continue;
            }
            if (cadidateTabActive.getParent() == null || currentTab == cadidateTabActive) {
                this.activeTabSeq.pop();
                continue;
            }
            return this.activeTabSeq.pop();
        }
        return null;
    }

    public void removeTabFromActiveSeq(Tab closeTab) {
        this.activeTabSeq.remove(closeTab);
    }

    public boolean isCheckVisibleOnlyForNextActive() {
        return this.isCheckVisibleOnlyForNextActive;
    }

    public void setCheckVisibleOnlyForNextActive(boolean isVisibleOnly) {
        this.isCheckVisibleOnlyForNextActive = isVisibleOnly;
    }
}

